#include "ScnMain.h"
#include "scngames.h"
#include "freestyledash.h"
#include "AtgSignin.h"
HRESULT CScnMain::OnInit( XUIMessageInit* pInitData, BOOL& bHandled )
{
	DebugMsg("CScnMain::OnInit");
	
	GenreDisp = L"";
    // Retrieve controls for later use.
    HRESULT hr = GetChildById( L"XBox360Games", &btnXBox360Games );
    hr = GetChildById( L"XBox1Games", &btnXBox1Games );
    hr = GetChildById( L"XBoxLiveArcade", &btnXBoxLiveArcade );
    hr = GetChildById( L"Homebrew", &btnHomebrew );
    hr = GetChildById( L"Emulators", &btnEmulators );
    hr = GetChildById( L"Favourites", &btnFavourites );
    hr = GetChildById( L"RecentGames", &btnRecent );
    hr = GetChildById( L"Date", &m_date );
    hr = GetChildById( L"Time", &m_time );
    hr = GetChildById( L"DateTime", &m_datetime );
	hr = GetChildById( L"TemperatureCPU", &m_CPUTemp );
	hr = GetChildById( L"TemperatureGPU", &m_GPUTemp );
	hr = GetChildById( L"TemperatureEDRAM", &m_EDRAMTemp );
	hr = GetChildById( L"TemperatureMB", &m_MBTemp );
	hr = GetChildById( L"IPAddress", &m_IPAddress );
	hr = GetChildById( L"TitleTemperatures", &m_TempInfo );
	hr = GetChildById( L"FreeHDD1", &m_HDD1Text );
	hr = GetChildById( L"FreeMU0", &m_MU0Text );
	hr = GetChildById( L"FreeUSB1", &m_USB1Text );
	hr = GetChildById( L"FreeUSB0", &m_USB0Text );
	hr = GetChildById( L"TitleDiskSpace", &m_DiskInfo );
	hr = GetChildById( L"GamerTag", &m_GamerTag );
	hr = GetChildById( L"GamerScore", &m_GamerScore );
	hr = GetChildById( L"SMCVer", &m_SMCVer );
	hr = GetChildById( L"Orientation", &m_Orientation );
	hr = GetChildById( L"TrayStatus", &m_TrayStat );
	hr = GetChildById( L"AVPack", &m_AVPack );
	hr = GetChildById( L"TitleSystemInfo", &m_InfoText );
	hr = GetChildById( L"GamerPic", &m_GamerPic );
	hr = GetChildById( L"ProfileBackground", &m_ProfileBack );

	ATG::SignIn::Initialize(0,4,FALSE,1);

	if (SaveSettings)
		DoSaveSettings();

	SetClock(m_date,m_time,m_datetime);
	SetTemps(m_CPUTemp, m_GPUTemp, m_EDRAMTemp, m_MBTemp, m_TempInfo);
	SetIp(m_IPAddress);
	SetDiskSpace(m_HDD1Text, m_MU0Text, m_USB1Text, m_USB0Text, m_DiskInfo);
	if(IsUserSignedIn(0))
	{
		//Show
		m_ProfileBack.SetShow(true);
		m_GamerTag.SetShow(true);
		m_GamerScore.SetShow(true);
		m_GamerPic.SetShow(true);
		SetGamerTag(m_GamerTag);
		SetGamerScore(m_GamerScore);
		ReadGamerPicture(m_GamerPic);
	}
	else
	{
		//Hide
		m_ProfileBack.SetShow(false);
		m_GamerTag.SetShow(false);
		m_GamerScore.SetShow(false);
		m_GamerPic.SetShow(false);
	}
	SetInfoText(m_SMCVer, m_TrayStat, m_Orientation, m_AVPack, m_InfoText);
	SetTimer(TM_CLOCK,1000);
	SetTimer(TM_LOADING,5);
	SetTimer(TM_INFO,200);

	if (FSpeed >= 45)
	{
		SetFanSpeed(1, FSpeed);
	}

	if (LedType == 1) //Temp Led
	{
		SetTempLEDS();
		SetTimer(TM_LED_TEMP, 15000);
	} 
	else
	{
		SetLedState(LedType);
	}

	DoSaveSettings();

    return S_OK;
}


//----------------------------------------------------------------------------------
// Handler for the button press message.
//----------------------------------------------------------------------------------
HRESULT CScnMain::OnNotifyPress( HXUIOBJ hObjPressed, BOOL& bHandled )
{
	GenreDisp = L"";

	ShowFavs = false;
	ShowRecent = false;
	ToDisplay = -1;

	if (hObjPressed == btnXBoxLiveArcade)
		ToDisplay = 0;
	if (hObjPressed == btnXBox360Games)
		ToDisplay = 1;
	if (hObjPressed == btnXBox1Games)
		ToDisplay = 2;
	if (hObjPressed == btnHomebrew)
		ToDisplay = 3;
	if (hObjPressed == btnEmulators)
		ToDisplay = 4;
	if (hObjPressed == btnFavourites)
		ShowFavs = true;
	if (hObjPressed == btnRecent)
		ShowRecent = true;

    bHandled = FALSE;
    return S_OK;
}

HRESULT CScnMain::OnTimer( XUIMessageTimer *pTimer, BOOL& bHandled )
{
    switch( pTimer->nId )
    {
    case TM_CLOCK:
		SetClock(m_date,m_time,m_datetime);
		SetInfoText(m_SMCVer, m_TrayStat, m_Orientation, m_AVPack, m_InfoText);
		break;
	case TM_INFO:
		SetTemps(m_CPUTemp, m_GPUTemp, m_EDRAMTemp, m_MBTemp, m_TempInfo);
		SetIp(m_IPAddress);
		SetDiskSpace(m_HDD1Text, m_MU0Text, m_USB1Text, m_USB0Text, m_DiskInfo);
	
		if(ATG::SignIn::Update()==1)
		{
			if(IsUserSignedIn(0))
			{
				//Show
				m_ProfileBack.SetShow(true);
				m_GamerTag.SetShow(true);
				m_GamerScore.SetShow(true);
				m_GamerPic.SetShow(true);
				SetGamerTag(m_GamerTag);
				SetGamerScore(m_GamerScore);
				ReadGamerPicture(m_GamerPic);
			}
			else
			{
				//Hide
				m_ProfileBack.SetShow(false);
				m_GamerTag.SetShow(false);
				m_GamerScore.SetShow(false);
				m_GamerPic.SetShow(false);
			}
		}
		break;
	case TM_LED_TEMP:
		SetTempLEDS();
		break;

	case TM_LOADING:
								
		
		if (ParentalControl)
		{
			KillTimer(TM_LOADING);

			HXUIOBJ hScene = NULL;
			HRESULT hResult = CXuiScene::SceneCreate( L"xbox360.xur", &hScene );
			DebugMsg("CXuiScene::SceneCreate( xbox360.xur, &hScene ) = %08x",hResult);
			hResult = CXuiScene::NavigateForward( hScene );
			DebugMsg("CXuiScene::NavigateForward( hScene ) = %08x",hResult);
		}
	}
    bHandled = TRUE;
    return S_OK;
}
